<?php
session_start();
header('Content-Type: application/json');
include("conex.php");

// Validar sesión
if (!isset($_SESSION['idusuario'])) {
    echo json_encode([['id' => '', 'nombre_marca' => '--- Seleccione ---']]);
    exit;
}

// Ejecutar consulta
$sql = "SELECT id, nombre_marca FROM tb_marca ORDER BY nombre_marca";
$result = mysqli_query($conex, $sql);

// Validar resultado
if (!$result) {
    echo json_encode([['id' => '', 'nombre_marca' => '--- Seleccione ---']]);
    exit;
}

// Arreglo de marcas con opción inicial
$marcas = [
    ['id' => '', 'nombre_marca' => '--- Seleccione ---']
];

while ($row = mysqli_fetch_assoc($result)) {
    $marcas[] = $row;
}

echo json_encode($marcas, JSON_UNESCAPED_UNICODE);
?>
