<?php
header('Content-Type: application/json');
include 'conex.php';

if (!$conex) {
    http_response_code(500);
    echo json_encode(['error' => 'Error de conexión a la base de datos']);
    exit;
}

$sql = "SELECT id, zona FROM tb_zona ORDER BY zona";
$res = mysqli_query($conex, $sql);

if (!$res) {
    http_response_code(500);
    echo json_encode(['error' => 'Error al ejecutar la consulta']);
    exit;
}

$zonas = [];

// Agregar opción vacía al inicio
$zonas[] = [
    'id' => '',
    'zona' => '--- Seleccione ---'
];

// Luego añadir las zonas reales
while ($row = mysqli_fetch_assoc($res)) {
    $zonas[] = $row;
}

echo json_encode($zonas);
?>

