<?php
include "conex.php";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $zona = trim($_POST['zona'] ?? '');
  $canton = trim($_POST['canton'] ?? '');

  if ($zona === '' || $canton === '') {
    echo json_encode(['success' => false, 'message' => 'Campos vacíos']);
    exit;
  }

  // Escapar valores para seguridad
  $zona = mysqli_real_escape_string($conex, $zona);
  $canton = mysqli_real_escape_string($conex, $canton);

  // Verificar si ya existe el cantón en la zona
  $check = mysqli_query($conex, "SELECT COUNT(*) as total FROM tb_canton WHERE id_zona = '$zona' AND canton = '$canton'");
  $result = mysqli_fetch_assoc($check);

  if ($result['total'] > 0) {
    echo json_encode(['success' => false, 'message' => 'Este cantón ya existe en la zona seleccionada.']);
    exit;
  }

  // Insertar nueva zona y cantón
  $query = "INSERT INTO tb_canton (id_zona, canton, activo, condicion) VALUES ('$zona', '$canton', 1, 1)";
  if (mysqli_query($conex, $query)) {
    echo json_encode(['success' => true, 'message' => 'Cantón agregado correctamente.']);
  } else {
    echo json_encode(['success' => false, 'message' => 'Error al guardar.']);
  }
}
?>
