<?php
declare(strict_types=1);
session_start();
header('Content-Type: application/json; charset=utf-8');

require_once __DIR__ . '/conex.php';

/* === Resolver conexión ($db puede ser $conex o $conn) === */
$db = null;
if (isset($conex) && $conex instanceof mysqli) { $db = $conex; }
elseif (isset($conn) && $conn instanceof mysqli) { $db = $conn; }

if (!$db) {
  http_response_code(500);
  echo json_encode(['success'=>false,'message'=>'Sin conexión a la base de datos']); exit;
}

/* === Verificar sesión (ajusta si no quieres forzarlo aquí) === */
if (!isset($_SESSION['idusuario'])) {
  http_response_code(401);
  echo json_encode(['success'=>false,'message'=>'Sesión expirada']); exit;
}

mysqli_set_charset($db, 'utf8mb4');
@mysqli_query($db, "SET time_zone='-05:00'");

/* === Entrada === */
$marca     = trim($_POST['marca']     ?? '');
$direccion = trim($_POST['direccion'] ?? '');
$telefono  = trim($_POST['telefono']  ?? '');
$email     = trim($_POST['email']     ?? '');
$contacto  = trim($_POST['contacto']  ?? '');
$telefonoc = trim($_POST['telefonoc'] ?? '');
$plan      = trim($_POST['plan']      ?? '');
$tiempo    = trim($_POST['tiempo']  ?? '');
$valorRaw  = $_POST['valor']          ?? '';

/* === Validaciones === */
if ($marca==='' || $direccion==='' || $telefono==='' || $email==='' || $contacto==='' || $telefonoc==='' || $plan===''  || $tiempo==='' || $valorRaw==='') {
  echo json_encode(['success'=>false,'message'=>'Todos los campos son obligatorios']); exit;
}
if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
  echo json_encode(['success'=>false,'message'=>'Email no válido']); exit;
}
if (!is_numeric($valorRaw)) {
  echo json_encode(['success'=>false,'message'=>'Valor debe ser numérico']); exit;
}
$valor = (float)$valorRaw;
if ($valor < 0) {
  echo json_encode(['success'=>false,'message'=>'Valor no puede ser negativo']); exit;
}

/* === Insert preparado === */
$sql = "INSERT INTO tb_marca
          (nombre_marca, direccion, telefono, email, contacto, telefono_contacto, plan, tiempo, valor, activo, condicion)
        VALUES (?,?,?,?,?,?,?,?,?, 1, 1)";

$stmt = $db->prepare($sql);
if (!$stmt) {
  http_response_code(500);
  echo json_encode(['success'=>false,'message'=>'Error al preparar SQL: '.$db->error]); exit;
}

/* 7 strings + 1 double = 'sssssssdd' */
if (!$stmt->bind_param('sssssssid', $marca, $direccion, $telefono, $email, $contacto, $telefonoc, $plan,  $tiempo, $valor)) {
  http_response_code(500);
  echo json_encode(['success'=>false,'message'=>'Error bind_param: '.$stmt->error]); exit;
}

$ok = $stmt->execute();
if (!$ok) {
  http_response_code(500);
  echo json_encode(['success'=>false,'message'=>'Error al guardar: '.$stmt->error]); exit;
}

echo json_encode(['success'=>true,'message'=>'Marca guardada correctamente']);
