<?php
session_start();
include("conex.php");

// Verificar sesión
if (!isset($_SESSION['idusuario'])) {
    echo json_encode(["success" => false, "message" => "Sesión expirada."]);
    exit;
}

// Función para obtener el ID desde nombre (marca, zona, cantón, video)
function obtenerIdPorNombre($conex, $tabla, $campoNombre, $valor) {
    $stmt = $conex->prepare("SELECT id FROM $tabla WHERE $campoNombre = ? LIMIT 1");
    $stmt->bind_param("s", $valor);
    $stmt->execute();
    $res = $stmt->get_result();
    if ($res->num_rows > 0) {
        return $res->fetch_assoc()['id'];
    }
    return null;
}

// Datos del formulario
$id     = isset($_POST['id']) ? intval($_POST['id']) : null;
$marca  = trim($_POST['marca'] ?? '');
$zona   = trim($_POST['zona'] ?? '');
$canton = trim($_POST['canton'] ?? '');
$video  = trim($_POST['video'] ?? '');
$fecha_inicio = trim($_POST['fechaini'] ?? '');
$fecha_corte  = trim($_POST['fechafin'] ?? '');
$activa = intval($_POST['activa'] ?? 0);

// Obtener los ID correspondientes desde nombre
$id_marca  = obtenerIdPorNombre($conex, 'tb_marca', 'nombre_marca', $marca);
$id_zona   = obtenerIdPorNombre($conex, 'tb_zona', 'zona', $zona);
$id_canton = obtenerIdPorNombre($conex, 'tb_canton', 'canton', $canton);
$id_video  = obtenerIdPorNombre($conex, 'tb_video', 'video', $video);

// Validar que todos los IDs existan
if (!$id_marca || !$id_zona || !$id_canton || !$id_video) {
    echo json_encode(["success" => false, "message" => "Datos inválidos: marca, zona, cantón o video no encontrados."]);
    exit;
}

if ($id) {
    // Actualizar registro existente
    $stmt = $conex->prepare("UPDATE tb_publicidad SET 
        id_marca = ?, id_zona = ?, id_canton = ?, id_video = ?, 
        fecha_inicio = ?, fecha_fin = ?
        WHERE id = ?");
    $stmt->bind_param("iiiissi", $id_marca, $id_zona, $id_canton, $id_video, $fecha_inicio, $fecha_corte, $id);
} else {
    // Insertar nuevo registro
    $stmt = $conex->prepare("INSERT INTO tb_publicidad 
        (id_marca, id_zona, id_canton, id_video, fecha_inicio, fecha_fin, activo, condicion) 
        VALUES (?, ?, ?, ?, ?, ?, ?, 1)");
    $stmt->bind_param("iiiissi", $id_marca, $id_zona, $id_canton, $id_video, $fecha_inicio, $fecha_corte, $activa);
}

if ($stmt->execute()) {
    echo json_encode(["success" => true]);
} else {
    echo json_encode(["success" => false, "message" => "Error al guardar: " . $stmt->error]);
}
