<?php
require 'conex.php';
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $marca = trim($_POST['marca'] ?? '');
    $modelo = trim($_POST['modelo'] ?? '');
    $serie = trim($_POST['serie'] ?? '');
    $estado = trim($_POST['estado'] ?? '');

    if ($marca === '' || $modelo === '' || $serie === '' || $estado === '') {
        echo json_encode(['success' => false, 'message' => 'Todos los campos son obligatorios.']);
        exit;
    }

    // Escapar valores
    $marca = mysqli_real_escape_string($conex, $marca);
    $modelo = mysqli_real_escape_string($conex, $modelo);
    $serie = mysqli_real_escape_string($conex, $serie);
    $estado = mysqli_real_escape_string($conex, $estado);

    // Verificar si ya existe la serie
    $check = mysqli_query($conex, "SELECT COUNT(*) as total FROM tb_table WHERE serie = '$serie'");
    $result = mysqli_fetch_assoc($check);

    if ($result['total'] > 0) {
        echo json_encode(['success' => false, 'message' => 'Esta serie ya existe.']);
        exit;
    }

    // Insertar el modelo
    $query = "INSERT INTO tb_table (marca, modelo, serie, estado, activa, condicion)
	VALUES ('$marca', '$modelo', '$serie', '$estado',1 , 1)";
    if (mysqli_query($conex, $query)) {
        echo json_encode(['success' => true, 'message' => 'Modelo agregado correctamente.']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Error al guardar en la base de datos.']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Método no permitido.']);
}
