<?php
// guardar_ubicacion.php
session_start();
include("conex.php");
header('Content-Type: application/json');

// Recibir datos vía POST
$id_tablet = $_POST['id_tablet'] ?? null;
$latitud = $_POST['latitud'] ?? null;
$longitud = $_POST['longitud'] ?? null;

if (!$id_tablet || !$latitud || !$longitud) {
    echo json_encode(['error' => 'Faltan parámetros']);
    exit();
}

// Validar datos básicos (puedes mejorar con filtros)
$latitud = floatval($latitud);
$longitud = floatval($longitud);
$id_tablet = htmlspecialchars($id_tablet, ENT_QUOTES, 'UTF-8');

// Guardar o actualizar ubicación en BD
// Asumo que tienes una tabla llamada ubicaciones_tablets con estos campos:
// id_tablet (varchar), latitud (decimal), longitud (decimal), fecha_hora (datetime)

try {
    $fecha_hora = date('Y-m-d H:i:s');
    
    // Consulta para insertar o actualizar (si ya existe)
    $sql = "INSERT INTO ubicaciones_tablets (id_tablet, latitud, longitud, fecha_hora) 
            VALUES (?, ?, ?, ?)
            ON DUPLICATE KEY UPDATE 
                latitud = VALUES(latitud), 
                longitud = VALUES(longitud), 
                fecha_hora = VALUES(fecha_hora)";
    $stmt = $conex->prepare($sql);
    $stmt->bind_param("sdds", $id_tablet, $latitud, $longitud, $fecha_hora);
    $stmt->execute();

    echo json_encode(['success' => true, 'message' => 'Ubicación guardada']);
} catch (Exception $e) {
    echo json_encode(['error' => $e->getMessage()]);
}
