<?php
require 'conex.php';
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $cooperativa = trim($_POST['cooperativa'] ?? '');
    $placa = trim($_POST['placa'] ?? '');
    $telefono = trim($_POST['telefono'] ?? '');
    $nombres = trim($_POST['nombres'] ?? '');
    $zona = trim($_POST['zona'] ?? '');
    $canton = trim($_POST['canton'] ?? '');
    $table = trim($_POST['table'] ?? '');

    // Validar campos
    if ($cooperativa === '' || $placa === '' || $telefono === '' || $nombres === '' || $zona === '' || $canton === '') {
        echo json_encode(['success' => false, 'message' => 'Todos los campos son obligatorios.']);
        exit;
    }

    // Escapar valores
    $cooperativa = mysqli_real_escape_string($conex, $cooperativa);
    $placa = mysqli_real_escape_string($conex, $placa);
    $telefono = mysqli_real_escape_string($conex, $telefono);
    $nombres = mysqli_real_escape_string($conex, $nombres);
    $zona = mysqli_real_escape_string($conex, $zona);
    $canton = mysqli_real_escape_string($conex, $canton);
    $table = mysqli_real_escape_string($conex, $table);

    // Validar que la placa no esté repetida
    $check = mysqli_query($conex, "SELECT COUNT(*) as total FROM tb_vehiculo WHERE placa = '$placa'");
    $result = mysqli_fetch_assoc($check);

    if ($result['total'] > 0) {
        echo json_encode(['success' => false, 'message' => 'La placa ya está registrada.']);
        exit;
    }

    // Insertar vehículo
    $query = "INSERT INTO tb_vehiculo (cooperativa, placa, telefono, nombre, id_zona, id_canton, id_table, activo, condicion)
              VALUES ('$cooperativa', '$placa', '$telefono', '$nombres', '$zona', '$canton', '$table', 1, 1)";

    if (mysqli_query($conex, $query)) {
        echo json_encode(['success' => true, 'message' => 'Vehículo registrado correctamente.']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Error al guardar en la base de datos.']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Método no permitido.']);
}
