<?php
declare(strict_types=1);

/* Capta cualquier BOM/espacio de includes */
ob_start();

header('Content-Type: application/json; charset=utf-8');
ini_set('display_errors', '0'); // evita romper el JSON
error_reporting(E_ALL);

session_start();
require_once __DIR__ . '/conex.php';

/* Nunca redirijas: responde JSON */
if (!isset($_SESSION['idusuario'])) {
  if (ob_get_length()) { ob_clean(); }
  echo json_encode(['data'=>[], 'error'=>'Sesión expirada.'], JSON_UNESCAPED_UNICODE);
  exit;
}

if (!isset($conex) || !$conex instanceof mysqli) {
  if (ob_get_length()) { ob_clean(); }
  echo json_encode(['data'=>[], 'error'=>'Sin conexión a la base de datos.'], JSON_UNESCAPED_UNICODE);
  exit;
}
mysqli_set_charset($conex, 'utf8mb4');

$sql = "SELECT id, video, ruta, activo
        FROM tb_video
        WHERE condicion = 1
        ORDER BY id DESC";
$res = mysqli_query($conex, $sql);

if (!$res) {
  if (ob_get_length()) { ob_clean(); }
  echo json_encode(['data'=>[], 'error'=>'Error en la consulta: '.mysqli_error($conex)], JSON_UNESCAPED_UNICODE);
  exit;
}

function to_utf8($s){ return is_string($s) ? mb_convert_encoding($s, 'UTF-8', 'UTF-8') : $s; }

$data = [];
while ($row = mysqli_fetch_assoc($res)) {
  $data[] = [
    'id'     => (int)$row['id'],
    'video'  => to_utf8((string)$row['video']),
    'ruta'   => to_utf8((string)$row['ruta']),
    'activo' => (int)$row['activo']
  ];
}

if (ob_get_length()) { ob_clean(); }
echo json_encode(['data'=>$data], JSON_UNESCAPED_UNICODE | JSON_INVALID_UTF8_SUBSTITUTE);
exit;
