<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$currentPage = basename($_SERVER['PHP_SELF']);

// Agrupamos las páginas por sección
$configPages = ['usuarios.php', 'zonas.php', 'cantones.php', 'vehiculos.php', 'table.php', 'video.php', 'marcas.php'];
$reportPages = ['reporte_pagos.php.php'];

$isConfigActive = in_array($currentPage, $configPages);
$isReportActive = in_array($currentPage, $reportPages);
?>
<style>
.sidebar {
    width: 250px;
    background-color: #2c3e50;
    color: white;
    min-height: 100vh;
    padding-top: 60px;
    position: fixed;
    top: 0;
    left: 0;
    overflow-y: auto;
    z-index: 1000;
    transition: all 0.3s ease;
}
@media (max-width: 768px) {
    .sidebar {
        transform: translateX(-100%);
    }
    .sidebar.show {
        transform: translateX(0);
    }
}
.sidebar a {
    display: block;
    color: white;
    padding: 12px 20px;
    text-decoration: none;
    transition: background 0.3s ease;
}
.sidebar a:hover,
.sidebar a.active {
    background-color: #34495e;
}
.sidebar i {
    margin-right: 10px;
}
.sidebar .submenu {
    display: none;
    background-color: #34495e;
}
.sidebar .submenu a {
    padding-left: 40px;
    font-size: 0.95em;
    background-color: #3d566e;
}
</style>

<div class="sidebar" id="sidebar">
    <a href="/urbanviews/views/pages/" class="<?= $currentPage === '/urbanviews/views/pages/' ? 'active' : '' ?>"><i class="fa fa-home"></i> <span>Inicio</span></a>

    <a href="#" class="submenu-toggle <?= $isConfigActive ? 'active' : '' ?>" data-target="configSubmenu">
        <i class="fas fa-cogs"></i> <span>Administración</span>
    </a>
    <ul class="submenu" id="configSubmenu" style="display: <?= $isConfigActive ? 'block' : 'none' ?>;">
        <li><a href="zonas.php" class="<?= $currentPage === 'zonas.php' ? 'active' : '' ?>"><i class="fas fa-sitemap"></i> Zonas</a></li>
        <li><a href="cantones.php" class="<?= $currentPage === 'cantones.php' ? 'active' : '' ?>"><i class="fas fa-sort-amount-down-alt"></i> Cantones</a></li>
        <li><a href="vehiculos.php" class="<?= $currentPage === 'vehiculos.php' ? 'active' : '' ?>"><i class="fas fa-car"></i> Vehículos</a></li>
        <li><a href="table.php" class="<?= $currentPage === 'table.php' ? 'active' : '' ?>"><i class="fas fa-television"></i> Table</a></li>
        <li><a href="video.php" class="<?= $currentPage === 'video.php' ? 'active' : '' ?>"><i class="fa fa-video-camera"></i> Video</a></li>
        <li><a href="marcas.php" class="<?= $currentPage === 'marcas.php' ? 'active' : '' ?>"><i class="fa fa-puzzle-piece"></i> Marcas</a></li>
    </ul>

    <a href="publicidad.php" class="<?= $currentPage === 'publicidad.php' ? 'active' : '' ?>"><i class="fa fa-bullhorn"></i> <span>Publicidad</span></a>

    <a href="#" class="submenu-toggle <?= $isReportActive ? 'active' : '' ?>" data-target="reportSubmenu">
        <i class="fas fa-chart-line"></i> <span>Reportes</span>
    </a>
    <ul class="submenu" id="reportSubmenu" style="display: <?= $isReportActive ? 'block' : 'none' ?>;">
        <li><a href="reporte.php" class="<?= $currentPage === 'reporte.php' ? 'active' : '' ?>"><i class="fas fa-dollar-sign"></i> General</a></li>
        <!--li><a href="ganadores.php" class="<?= $currentPage === 'ganadores.php' ? 'active' : '' ?>"><i class="fas fa-trophy"></i> Ganadores por día</a></li>
        <li><a href="caducados_r.php" class="<?= $currentPage === 'caducados_r.php' ? 'active' : '' ?>"><i class="fas fa-times-circle"></i> Ganadores caducados</a></li>
        <li><a href="reporte_fecha.php" class="<?= $currentPage === 'reporte_fecha.php' ? 'active' : '' ?>"><i class="fas fa-calendar-alt"></i> Reporte por fecha</a></li>
        <li><a href="reporte_u_p.php" class="<?= $currentPage === 'reporte_u_p.php' ? 'active' : '' ?>"><i class="fas fa-coins"></i> Utilidad - Pérdida 2 cifras</a></li>
        <li><a href="reporte_u_p3c.php" class="<?= $currentPage === 'reporte_u_p3c.php' ? 'active' : '' ?>"><i class="fas fa-coins"></i> Utilidad - Pérdida 3 cifras</a></li>
        <li><a href="reporte_u_p4c.php" class="<?= $currentPage === 'reporte_u_p4c.php' ? 'active' : '' ?>"><i class="fas fa-coins"></i> Utilidad - Pérdida 4 cifras</a></li-->
    </ul>

    <!--a href="historial.php" class="<?= $currentPage === 'historial.php' ? 'active' : '' ?>"><i class="fa fa-history"></i> <span>Historial</span></a-->
</div>

<script>
// Controlar submenús dinámicamente
document.addEventListener("DOMContentLoaded", function () {
    document.querySelectorAll(".submenu-toggle").forEach(toggle => {
        toggle.addEventListener("click", function (e) {
            e.preventDefault();
            const targetId = this.dataset.target;
            const submenu = document.getElementById(targetId);
            const isVisible = submenu.style.display === "block";

            // Cierra todos los submenús
            document.querySelectorAll(".submenu").forEach(ul => ul.style.display = "none");
            document.querySelectorAll(".submenu-toggle").forEach(t => t.classList.remove("active"));

            // Abre el submenu si estaba cerrado
            if (!isVisible) {
                submenu.style.display = "block";
                this.classList.add("active");
            }
        });
    });
});
</script>
