<?php
ob_clean();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();
include("conex.php");
header('Content-Type: application/json');

try {
    $sql = "
        SELECT t1.id_tablet, t1.latitud, t1.longitud, t1.fecha_hora, t3.activa
        FROM tb_ubicaciones_tablets t1
        INNER JOIN (
            SELECT id_tablet, MAX(fecha_hora) AS ultima_fecha
            FROM tb_ubicaciones_tablets
            GROUP BY id_tablet
        ) t2 ON t1.id_tablet = t2.id_tablet AND t1.fecha_hora = t2.ultima_fecha
        INNER JOIN tb_table t3 ON t1.id_tablet = t3.id
        WHERE t3.condicion = 1
    ";

    $result = $conex->query($sql);

    if (!$result) {
        throw new Exception("Error en la consulta SQL: " . $conex->error);
    }

    $ubicaciones = [];
    while ($row = $result->fetch_assoc()) {
        $ubicaciones[] = [
            'id_tablet'   => $row['id_tablet'],
            'latitud'     => (float)$row['latitud'],
            'longitud'    => (float)$row['longitud'],
            'fecha_hora'  => $row['fecha_hora'],
            'activa'      => (int)$row['activa']
        ];
    }

    echo json_encode($ubicaciones);
} catch (Exception $e) {
    echo json_encode(['error' => $e->getMessage()]);
}

$conex->close();
?>
