<?php
include 'conex.php';
header('Content-Type: application/json');

$hoy = date('Y-m-d');

// Obtener zona por nombre (requerido)
$nombreZona = isset($_GET['zona']) ? trim($_GET['zona']) : '';
$nombreCanton = isset($_GET['canton']) ? trim($_GET['canton']) : '';

// Validar que se envíe zona
if ($nombreZona === '') {
    echo json_encode([
        'success' => false,
        'message' => 'Debe proporcionar el nombre de una zona válida.'
    ]);
    exit;
}

// Dominio base (ajusta para producción si es necesario)
$dominio = 'https://laganamass.com/urbanviews/views/pages/';

// Consulta base
$sql = "SELECT 
            p.id, 
            p.fecha_inicio, 
            p.fecha_fin, 
            p.activo, 
            m.nombre_marca, 
            z.zona, 
            c.canton, 
            v.video,
            v.ruta
        FROM tb_publicidad AS p 
        INNER JOIN tb_marca AS m ON m.id = p.id_marca
        INNER JOIN tb_zona AS z ON z.id = p.id_zona
        INNER JOIN tb_canton AS c ON c.id = p.id_canton
        INNER JOIN tb_video AS v ON v.id = p.id_video
        WHERE p.condicion = 1
          AND p.fecha_inicio <= ?
          AND p.fecha_fin >= ?
          AND z.zona = ?";

// Parámetros iniciales
$params = [$hoy, $hoy, $nombreZona];
$types = "sss";

// Si se envió cantón, filtrar también por nombre
if ($nombreCanton !== '') {
    $sql .= " AND c.canton = ?";
    $params[] = $nombreCanton;
    $types .= "s";
}

$stmt = $conex->prepare($sql);
if (!$stmt) {
    echo json_encode([
        'success' => false,
        'message' => 'Error al preparar la consulta: ' . $conex->error
    ]);
    exit;
}

$stmt->bind_param($types, ...$params);
$stmt->execute();
$result = $stmt->get_result();

$videos = [];

while ($row = $result->fetch_assoc()) {
    $row['url_completa'] = rtrim($dominio, '/') . '/' . ltrim($row['ruta'], '/');
    $videos[] = $row;
}

if (empty($videos)) {
    echo json_encode([
        'success' => false,
        'message' => 'No se encontraron videos para la zona especificada.'
    ]);
} else {
    echo json_encode([
        'success' => true,
        'data' => $videos
    ]);
}

$stmt->close();
$conex->close();
?>
