<?php
session_start();
if (!isset($_SESSION['usuario']) || empty($_SESSION['usuario'])) {
    header('Location: ../../index.php');
    exit();
}
$usuario = $_SESSION['usuario'];
?>
<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8" />
<title>URBANVIEW</title>
<link rel="shortcut icon" href="../../resources/img/logour.ico" />
<meta name="viewport" content="width=device-width, initial-scale=1" />

<!-- Bootstrap 5 CSS -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
<!-- FontAwesome -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet" />
<!-- DataTables CSS -->
<link href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap5.min.css" rel="stylesheet" />

<style>
html, body { height: 100%; margin: 0; overflow: hidden; font-family: Arial, Helvetica, sans-serif; }
body { display: flex; flex-direction: column; }
.topbar {
  height: 60px; background: #343a40; color: #fff; display: flex; align-items: center;
  justify-content: space-between; padding: 0 20px; position: fixed; top: 0; left: 0; right: 0; z-index: 1000;
}
.wrapper { display: flex; flex-grow: 1; margin-top: 60px; height: calc(100vh - 60px); overflow: hidden; }
.sidebar {
  width: 250px; background: #343a40; padding: 20px; overflow-y: auto; flex-shrink: 0; transition: width 0.3s ease;
}
.sidebar.collapsed { width: 80px; }
.sidebar a { color: #fff; text-decoration: none; padding: 12px; display: flex; align-items: center; }
.main-content {
  flex-grow: 1; height: 100%; display: flex; flex-direction: column; margin-left: 250px;
  padding: 20px; transition: margin-left 0.3s ease; overflow-y: auto;
}
.sidebar.collapsed ~ .main-content { margin-left: 80px; }
.info { display: flex; align-items: center; gap: 1rem; }
@media (max-width: 768px) {
  .sidebar {
    position: fixed; top: 60px; left: 0; height: calc(100% - 60px); z-index: 999;
    transform: translateX(-100%); transition: transform 0.3s ease; width: 250px;
  }
  .sidebar.show { transform: translateX(0); }
  .main-content { margin-left: 0 !important; }
  .wrapper { flex-direction: column; }
}
/* Switch estilo iOS */
.switch { position: relative; display: inline-block; width: 44px; height: 22px; }
.switch input { opacity: 0; width: 0; height: 0; }
.slider {
  position: absolute; cursor: pointer; background-color: #ccc; border-radius: 34px;
  top: 0; left: 0; right: 0; bottom: 0; transition: .4s;
}
.slider:before {
  position: absolute; content: ""; height: 16px; width: 16px; left: 3px; bottom: 3px;
  background-color: white; transition: .4s; border-radius: 50%;
}
input:checked + .slider { background-color: #28a745; }
input:checked + .slider:before { transform: translateX(22px); }
</style>
</head>
<body>
<header class="topbar">
  <button class="btn btn-dark" onclick="toggleSidebar()" aria-label="Toggle sidebar">
    <i class="fas fa-bars"></i>
  </button>
  <span>URBANVIEW</span>
  <div class="info">
    <span><?=htmlspecialchars($usuario, ENT_QUOTES, 'UTF-8');?></span>
    <span id="fechaActual"></span>
    <span id="horaActual"></span>
    <button class="btn btn-sm btn-danger" onclick="cerrarSesion(event)">
      <i class="fas fa-sign-out-alt"></i>
    </button>
  </div>
</header>

<div class="wrapper">
  <nav class="sidebar"><?php include "menu.php"; ?></nav>
  <div class="main-content">
    <div class="row mb-3">
      <div class="col-md-3">
        <button id="nuevaFila" class="btn btn-success mt-3"><i class="fas fa-plus"></i> Nueva fila</button>
      </div>
    </div>

    <div class="table-responsive">
      <table id="publicidad" class="table table-striped table-bordered" style="width:100%">
        <thead class="table-dark">
          <tr>
            <th>MARCA</th>
            <th>ZONA</th>
            <th>CANTÓN</th>
            <th>VIDEO</th>
            <th>INICIO</th>
            <th>CORTE</th>
            <th>ACTIVO</th>
            <th>ACCIÓN</th>
          </tr>
        </thead>
        <tbody></tbody>
      </table>
    </div>
  </div>
</div>

<!-- Modal para registrar pago -->
<div class="modal fade" id="modalPago" tabindex="-1" aria-labelledby="modalPagoLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <form id="formPago">
        <div class="modal-header">
          <h5 class="modal-title" id="modalPagoLabel">Registrar Pago</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
        </div>
        <div class="modal-body">
          <input type="hidden" id="pagoIdPublicidad"/>
          <input type="hidden" id="pagoIdmarca"/>

          <!-- Plan / Tiempo (solo lectura) -->
          <div class="row g-2">
            <div class="col-12 col-md-6">
              <div class="mb-3">
                <label for="pagoPlan" class="form-label">Plan</label>
                <input type="text" class="form-control" id="pagoPlan" name="plan" readonly>
              </div>
            </div>
            <div class="col-12 col-md-6">
              <div class="mb-3">
                <label for="pagoTiempo" class="form-label">Tiempo</label>
                <input type="text" class="form-control" id="pagoTiempo" name="tiempo" readonly>
              </div>
            </div>
          </div>

          <!-- Resumen de pagos (auto-relleno) -->
          <div id="pagoResumen" class="mb-2 d-none">
            <div class="row g-2">
              <div class="col-6">
                <span class="badge bg-primary w-100" id="badgeRealizados">0 pagos realizados</span>
              </div>
              <div class="col-6">
                <span class="badge bg-warning text-dark w-100" id="badgePendientes">0 pagos pendientes</span>
              </div>
            </div>
            <div class="progress my-2" style="height: 10px;">
              <div class="progress-bar" id="barraProgreso" role="progressbar" style="width:0%" aria-valuemin="0" aria-valuemax="100"></div>
            </div>
            <div class="d-flex justify-content-between small text-muted">
              <div>Total pagado: $<span id="lblTotalPagado">0.00</span></div>
              <div>Avance: <span id="lblPorcentaje">0%</span></div>
            </div>
          </div>

          <div class="mb-3">
            <label for="pagoMetodo" class="form-label">Método de Pago</label>
            <select id="pagoMetodo" class="form-select" required>
              <option value="">Selecciona...</option>
              <option value="Efectivo">Efectivo</option>
              <option value="Transferencia">Transferencia</option>
              <option value="Tarjeta">Tarjeta</option>
            </select>
          </div>
          <div class="mb-3">
            <label for="pagoMonto" class="form-label">Monto</label>
            <input type="number" min="0" step="0.01" class="form-control" id="pagoMonto" required />
          </div>
          <div class="mb-3">
            <label for="prox_fecha" class="form-label">Próxima fecha de corte</label>
            <input type="date" class="form-control" name="prox_fecha" id="prox_fecha" required />
          </div>
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">Registrar</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- JS: jQuery, Bootstrap, DataTables, SweetAlert -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
let tabla;
let marcasCache = [];
let zonasCache = [];
let cantonesCache = {};
let videoCache = [];

/* ===== Cargas con caché ===== */
function cargarMarcas(force=false) {
  if (Array.isArray(marcasCache) && marcasCache.length && !force) {
    return $.Deferred().resolve(marcasCache).promise();
  }
  return $.getJSON('get_marcas.php')
    .then(function(resp){
      let arr = Array.isArray(resp) ? resp : (resp && Array.isArray(resp.data) ? resp.data : []);
      if (!Array.isArray(arr)) arr = [];
      marcasCache = arr;
      return marcasCache;
    }, function(xhr){
      console.error('get_marcas.php error:', xhr?.status, xhr?.responseText);
      marcasCache = [];
      return marcasCache;
    });
}
function cargarZonas() {
  if (zonasCache.length > 0) return $.Deferred().resolve(zonasCache).promise();
  return $.getJSON('get_zonas.php', function(data) { zonasCache = data || []; });
}
function cargarCantones(idZona) {
  if (cantonesCache[idZona]) return $.Deferred().resolve(cantonesCache[idZona]).promise();
  return $.getJSON('get_cantones.php', { id_zona: idZona }, function(data) { cantonesCache[idZona] = data || []; });
}
function cargarVideo() {
  if (videoCache.length > 0) return $.Deferred().resolve(videoCache).promise();
  return $.getJSON('get_videos.php', function(data) { videoCache = data || []; });
}

/* ===== Helpers ===== */
function convertirFechaISO(fecha) {
  if (!fecha) return '';
  if (fecha.includes('/')) {
    const p = fecha.split('/');
    if (p.length === 3) return `${p[2]}-${p[1].padStart(2,'0')}-${p[0].padStart(2,'0')}`;
  }
  return fecha;
}
function obtenerValorCelda(fila, index) {
  const celda = fila.find(`td:eq(${index})`);
  const input = celda.find('input');
  if (input.length) return input.val();
  const select = celda.find('select');
  if (select.length) return select.find('option:selected').val();
  return celda.text().trim();
}
function obtenerIdDeSelectOCache(fila, colIndex, cache, propNombre, propId) {
  const celda = fila.find('td').eq(colIndex);
  const sel = celda.find('select');
  if (sel.length) return sel.find('option:selected').data('id') || null;
  const nombre = celda.text().trim();
  const item = (cache || []).find(x => (x[propNombre] || '').toString() === nombre);
  return item ? item[propId] : null;
}
function _norm(s){
  return (s || '').toString().normalize('NFD').replace(/[\u0300-\u036f]/g,'').trim().toLowerCase();
}
function parseNum(n){
  if (n === null || n === undefined) return NaN;
  const s = String(n).replace(/\s+/g,'').replace(/\./g,'').replace(',', '.');
  const v = parseFloat(s);
  return Number.isFinite(v) ? v : NaN;
}

/* ===== Topbar ===== */
function actualizarHora() {
  const ahora = new Date();
  const opF = { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' };
  const opH = { hour: '2-digit', minute: '2-digit', second: '2-digit' };
  document.getElementById('fechaActual').textContent = ahora.toLocaleDateString('es-ES', opF);
  document.getElementById('horaActual').textContent = ahora.toLocaleTimeString('es-ES', opH);
}
setInterval(actualizarHora, 1000);
actualizarHora();

function toggleSidebar() {
  let sidebar = document.querySelector('.sidebar');
  if (window.innerWidth <= 768) sidebar.classList.toggle('show');
  else sidebar.classList.toggle('collapsed');
}
document.addEventListener('click', function(e) {
  const sidebar = document.querySelector('.sidebar');
  const toggleBtn = e.target.closest('button[onclick="toggleSidebar()"]');
  if (window.innerWidth <= 768 && !sidebar.contains(e.target) && !toggleBtn) {
    sidebar.classList.remove('show');
  }
});
function cerrarSesion(e) {
  Swal.fire({
    title: '¿Cerrar sesión?',
    icon: 'warning',
    showCancelButton: true,
    confirmButtonText: 'Sí',
    cancelButtonText: 'No'
  }).then(res => {
    if (res.isConfirmed) {
      fetch('../../controllers/usuario.php', {
        method: 'POST',
        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
        body: new URLSearchParams({boton: 'cerrar'})
      }).then(response => {
        if (response.ok) window.location.href = '../../index.php';
        else throw new Error('Error al cerrar sesión');
      }).catch(err => Swal.fire('Error', err.message, 'error'));
    }
  });
}

/* ========= Resumen de pagos ========= */
function formatMoney(n) {
  n = Number(n || 0);
  return n.toLocaleString('es-EC', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
}
function resetResumenUI() {
  $('#pagoResumen').addClass('d-none');
  $('#badgeRealizados').text('0 pagos realizados');
  $('#badgePendientes').text('0 pagos pendientes');
  $('#lblTotalPagado').text('0.00');
  $('#lblPorcentaje').text('0%');
  $('#barraProgreso').css('width', '0%').removeClass('bg-danger bg-warning bg-success');
}
function pintarResumen(stats, tiempo) {
  const $wrap = $('#pagoResumen');
  if (!stats) { $wrap.addClass('d-none'); return; }

  const realizados = Number(stats.pagos_realizados || 0);
  const esperados  = Number(tiempo || stats.pagos_esperados || 0);
  const pendientes = Math.max(0, esperados - realizados);
  const totalPagado = Number(stats.total_pagado || 0);
  const porcentaje = esperados > 0 ? Math.min(100, Math.round((realizados / esperados) * 100)) : (realizados > 0 ? 100 : 0);

  $('#badgeRealizados').text(`${realizados} pago${realizados===1?'':'s'} realizados`);
  $('#badgePendientes').text(`${pendientes} pago${pendientes===1?'':'s'} pendientes`);
  $('#lblTotalPagado').text(formatMoney(totalPagado));
  $('#lblPorcentaje').text(`${porcentaje}%`);
  $('#barraProgreso').css('width', `${porcentaje}%`).attr('aria-valuenow', porcentaje);

  const $bar = $('#barraProgreso').removeClass('bg-danger bg-warning bg-success');
  if (porcentaje < 50) $bar.addClass('bg-danger');
  else if (porcentaje < 100) $bar.addClass('bg-warning');
  else $bar.addClass('bg-success');

  $wrap.removeClass('d-none');
}
async function cargarStatsMarca(idMarca) {
  if (!idMarca) return null;
  try {
    const r = await fetch(`get_marca_stats.php?id=${encodeURIComponent(idMarca)}`);
    const j = await r.json();
    return (j && j.success) ? j.data : null;
  } catch (e) {
    console.error('get_marca_stats (id) error:', e);
    return null;
  }
}
async function cargarStatsMarcaByNombre(nombre){
  if (!nombre) return null;
  try{
    const r = await fetch(`get_marca_stats.php?nombre=${encodeURIComponent(nombre)}`);
    const j = await r.json();
    return (j && j.success) ? j.data : null;
  }catch(e){
    console.error('get_marca_stats (nombre) error:', e);
    return null;
  }
}

/* ===== Página ===== */
$(document).ready(function () {
  tabla = $('#publicidad').DataTable({
    ordering: false,
    ajax: { url: 'funcion_publicidad.php', dataSrc: 'data' },
    columns: [
      { data: 'marca'  },   // 0
      { data: 'zona'   },   // 1
      { data: 'canton' },   // 2
      { data: 'video'  },   // 3
      { data: 'fechai' },   // 4
      { data: 'fechaf' },   // 5
      {                   // 6
        data: 'activo',
        render: function(data) {
          return `
            <label class="switch">
              <input type="checkbox" class="activar" ${data == 1 ? 'checked' : ''}>
              <span class="slider"></span>
            </label>`;
        }
      },
      {                   // 7
        data: null,
        orderable: false,
        render: function(_, __, row) {
          const hoy = new Date(); hoy.setHours(0,0,0,0);
          let diffDias = null, texto = '', clase = 'btn-primary';
          if (row.fechaf) {
            const [Y,M,D] = row.fechaf.split('-').map(Number);
            const fin = new Date(Y, M-1, D); fin.setHours(0,0,0,0);
            diffDias = Math.ceil((fin - hoy)/(1000*60*60*24));
            if (row.pagado) { texto='Pago registrado'; clase='btn-success'; }
            else if (diffDias < 0) { texto=`Venció hace ${Math.abs(diffDias)} día${Math.abs(diffDias)===1?'':'s'}`; clase='btn-secondary'; }
            else if (diffDias <= 3) { texto=`Faltan ${diffDias} día${diffDias===1?'':'s'} para la fecha de corte`; clase='btn-danger'; }
            else if (diffDias <= 10) { texto=`Faltan ${diffDias} días para la fecha de corte`; clase='btn-warning'; }
            else { texto=`Faltan ${diffDias} días para la fecha de corte`; }
          } else { texto='Fecha de corte no definida'; clase='btn-secondary'; }
          return `
            <button class="btn btn-sm ${clase} pagar" title="${texto}">
              <i class="fas fa-dollar-sign"></i> ${row.pagado ? 'Pagado' : 'Pago'}
            </button>
            <button class="btn btn-sm btn-success guardar" title="Guardar"><i class="fas fa-save"></i></button>
            <button class="btn btn-sm btn-danger eliminar" title="Eliminar"><i class="fas fa-trash-alt"></i></button>`;
        }
      }
    ],
    columnDefs: [{ targets: [0,1,2,3,4,5], className: 'editable' }]
  });

  // Tooltips
  tabla.on('draw', function () {
    document.querySelectorAll('#publicidad [title]').forEach(el => new bootstrap.Tooltip(el));
  });

  /* ====== Celdas editables (con actualización de row.data) ====== */
  function actualizarCantonPorZona(fila, idZonaSeleccionada, cantonActual = '') {
    cargarCantones(idZonaSeleccionada).done(function(cantones) {
      const cantonCell = fila.find('td').eq(2);
      let cantonSelect = '<select class="form-select form-select-sm canton-select">';
      cantones.forEach(canton => {
        const selected = canton.canton === cantonActual ? 'selected' : '';
        cantonSelect += `<option value="${canton.canton}" data-id="${canton.id}" ${selected}>${canton.canton}</option>`;
      });
      cantonSelect += '</select>';
      cantonCell.html(cantonSelect);
      cantonCell.removeClass('editable');
      const $sel = cantonCell.find('select').focus();

      // 🔐 Actualiza el objeto de la fila cuando cambie Canton
      $sel.on('change', function(){
        const txt = $(this).val();
        const idc = $(this).find('option:selected').data('id') || null;
        const row = tabla.row(fila);
        const rd  = row.data() || {};
        rd.canton = txt;
        rd.id_canton = idc;
        row.data(rd); // no forzamos draw
      });
    });
  }

  $('#publicidad tbody').on('click', 'td.editable', function () {
    const cell = tabla.cell(this);
    const colIndex = cell.index().column;
    const $td = $(cell.node());
    const fila = $(this).closest('tr');

    if (colIndex === 0) { // Marca
      cargarMarcas().done(function(marcas) {
        let html = '<select class="form-select form-select-sm">';
        marcas.forEach(marca => {
          const selected = marca.nombre_marca === cell.data() ? 'selected' : '';
          html += `<option value="${marca.nombre_marca}" data-id="${marca.id}" ${selected}>${marca.nombre_marca}</option>`;
        });
        html += '</select>';
        $td.html(html).removeClass('editable');

        const $sel = $td.find('select').focus();
        $sel.on('change', function(){
          const val   = $(this).val();
          const idSel = $(this).find('option:selected').data('id') || null;

          // 🔐 Actualiza visual + datos de DataTables
          $td.text(val).addClass('editable');
          const row = tabla.row(fila);
          const rd  = row.data() || {};
          rd.marca = val;       // <<<<<< NECESARIO
          rd.id_marca = idSel;  // <<<<<< NECESARIO
          row.data(rd);         // mantiene la fila sin redibujar toda la tabla
        });
      });
    } else if (colIndex === 1) { // Zona
      cargarZonas().done(function(zonas) {
        let html = '<select class="form-select form-select-sm zona-select">';
        zonas.forEach(z => {
          const sel = z.zona === cell.data() ? 'selected' : '';
          html += `<option value="${z.zona}" data-id="${z.id}" ${sel}>${z.zona}</option>`;
        });
        html += '</select>';
        $td.html(html).removeClass('editable');
        const $sel = $td.find('select').focus();

        $sel.on('change', function() {
          const idZona = $(this).find('option:selected').data('id') || null;
          const txt    = $(this).val();

          // 🔐 Guarda zona e id_zona y limpia canton/id_canton
          const row = tabla.row(fila);
          const rd  = row.data() || {};
          rd.zona = txt;
          rd.id_zona = idZona;
          rd.canton = '';     // se reinicia porque cambia la zona
          rd.id_canton = null;
          row.data(rd);

          // pinta texto visible y refresca cantones de esa zona
          $td.text(txt).addClass('editable');
          actualizarCantonPorZona(fila, idZona);
        });
      });
    } else if (colIndex === 2) { // Cantón
      $.when(cargarZonas()).done(function(){
        const idZona = obtenerIdDeSelectOCache(fila, 1, zonasCache, 'zona', 'id');
        if (!idZona) { Swal.fire('Primero selecciona la zona', '', 'warning'); return; }
        actualizarCantonPorZona(fila, idZona, cell.data());
      });
    } else if (colIndex === 3) { // Video
      cargarVideo().done(function(videos) {
        let html = '<select class="form-select form-select-sm">';
        videos.forEach(video => {
          const sel = video.video === cell.data() ? 'selected' : '';
          html += `<option value="${video.video}" data-id="${video.id}" ${sel}>${video.video}</option>`;
        });
        html += '</select>';
        $td.html(html).removeClass('editable');
        const $sel = $td.find('select').focus();

        $sel.on('change', function(){
          const txt = $(this).val();
          const idv = $(this).find('option:selected').data('id') || null;
          // 🔐 guarda en row.data
          const row = tabla.row(fila);
          const rd  = row.data() || {};
          rd.video = txt;
          rd.id_video = idv;
          row.data(rd);
          // deja el texto visible
          $td.text(txt).addClass('editable');
        });
      });
    } else if (colIndex === 4 || colIndex === 5) { // Fechas
      const val = convertirFechaISO(cell.data());
      $td.html(`<input type="date" class="form-control form-control-sm" value="${val}">`)
         .removeClass('editable');
      const $inp = $td.find('input').focus();

      $inp.on('change', function(){
        const txt = $(this).val();
        const row = tabla.row(fila);
        const rd  = row.data() || {};
        if (colIndex === 4) rd.fechai = txt;
        else rd.fechaf = txt;
        row.data(rd);
        $td.text(txt).addClass('editable');
      });
    }
  });

  // Blur genérico (por si hace click fuera sin cambiar nada)
  $('#publicidad tbody').on('blur', 'td input, td select', function () {
    const celda = $(this).closest('td');
    const valor = $(this).is('select') ? $(this).find('option:selected').val() : $(this).val();
    celda.text(valor).addClass('editable');
  });

  // Nueva fila
  $('#nuevaFila').on('click', function () {
    tabla.row.add({
      id: '',
      marca: '',
      id_marca: null,
      zona: '',
      id_zona: null,
      canton: '',
      id_canton: null,
      video: '',
      id_video: null,
      fechai: '',
      fechaf: '',
      activo: 0,
      pagado: false
    }).draw(false);
  });

  // Cambiar estado activo
  $('#publicidad tbody').on('change', 'input.activar', function () {
    const fila = $(this).closest('tr');
    const datos = tabla.row(fila).data();
    const nuevoEstado = $(this).is(':checked') ? 1 : 0;
    if (!datos.id) return;

    $.post('actualizar_estado_publicidad.php', { id: datos.id, activo: nuevoEstado }, function(resp) {
      if (resp.success) {
        Swal.fire({ toast:true, position:'top-end', icon:'success', title:'Estado actualizado', timer:1000, showConfirmButton:false });
        tabla.ajax.reload(null, false);
      } else {
        Swal.fire('Error', resp.message || 'No se pudo actualizar estado', 'error');
        $(fila).find('input.activar').prop('checked', !nuevoEstado);
      }
    }, 'json');
  });

  // Guardar fila
  $('#publicidad tbody').on('click', 'button.guardar', function () {
    const fila = $(this).closest('tr');
    const datosFila = tabla.row(fila).data();
    const marca   = obtenerValorCelda(fila, 0);
    const zona    = obtenerValorCelda(fila, 1);
    const canton  = obtenerValorCelda(fila, 2);
    const video   = obtenerValorCelda(fila, 3);
    const fechai  = obtenerValorCelda(fila, 4);
    const fechaf  = obtenerValorCelda(fila, 5);
    const activo  = fila.find('input.activar').is(':checked') ? 1 : 0;

    if (!marca || !zona || !canton || !video || !fechai || !fechaf) {
      Swal.fire('Completa todos los campos antes de guardar.', '', 'warning');
      return;
    }

    $.when(cargarMarcas(), cargarZonas(), cargarVideo()).done(function(){
      const id_marca = obtenerIdDeSelectOCache(fila, 0, marcasCache, 'nombre_marca', 'id');
      const id_zona  = obtenerIdDeSelectOCache(fila, 1, zonasCache, 'zona', 'id');

      if (!id_zona) { Swal.fire('Zona inválida', '', 'error'); return; }

      cargarCantones(id_zona).done(function(cants){
        const elegido = cants.find(c => c.canton === canton);
        const id_canton = elegido ? elegido.id : null;
        const id_video  = obtenerIdDeSelectOCache(fila, 3, videoCache, 'video', 'id');

        $.post('guardar_publicidad.php', {
          id: datosFila.id || '',
          marca, zona, canton, video,
          id_marca, id_zona, id_canton, id_video,
          fechai, fechaf,
          activo
        }, function(resp) {
          if (resp.success) {
            Swal.fire('Guardado', 'La publicidad fue guardada exitosamente.', 'success');
            tabla.ajax.reload(null, false);
          } else {
            Swal.fire('Error', resp.message || 'No se pudo guardar.', 'error');
          }
        }, 'json');
      });
    });
  });

  // Eliminar fila
  $('#publicidad tbody').on('click', 'button.eliminar', function () {
    const fila = $(this).closest('tr');
    const datosFila = tabla.row(fila).data();

    if (!datosFila.id) { tabla.row(fila).remove().draw(); return; }

    Swal.fire({
      title: '¿Eliminar esta publicidad?',
      icon: 'warning',
      showCancelButton: true,
      confirmButtonText: 'Sí, eliminar',
      cancelButtonText: 'Cancelar'
    }).then((result) => {
      if (result.isConfirmed) {
        $.post('eliminar_publicidad.php', { id: datosFila.id }, function(resp) {
          if (resp.success) {
            Swal.fire('Eliminado', 'Publicidad eliminada.', 'success');
            tabla.ajax.reload(null, false);
          } else {
            Swal.fire('Error', resp.message || 'No se pudo eliminar.', 'error');
          }
        }, 'json');
      }
    });
  });

  /* ========= ABRIR MODAL DE PAGO ========= */
  $('#publicidad tbody').on('click', '.pagar', async function () {
    const fila = $(this).closest('tr');
    const data = tabla.row(fila).data();

    if (!data?.id) {
      Swal.fire('Advertencia', 'Primero debes guardar esta fila antes de registrar un pago.', 'warning');
      return;
    }

    $('#pagoIdPublicidad').val(data.id);
    $('#pagoIdmarca').val(data.id_marca || '');

    if (data.fechaf) {
      const [Y, M, D] = String(data.fechaf).split('-').map(Number);
      const base = new Date(Y, (M||1)-1, D||1);
      base.setDate(base.getDate() + 30);
      const yyyy = base.getFullYear();
      const mm   = String(base.getMonth() + 1).padStart(2, '0');
      const dd   = String(base.getDate()).padStart(2, '0');
      $('#prox_fecha').val(`${yyyy}-${mm}-${dd}`);
    } else {
      $('#prox_fecha').val('');
    }

    await cargarMarcas();
    const lista = Array.isArray(marcasCache) ? marcasCache : [];

    // Resolver id_marca fiable
    let idMarca = data.id_marca || '';
    if (!idMarca && lista.length && data.marca) {
      const m = lista.find(x => _norm(x.nombre_marca) === _norm(data.marca));
      if (m?.id) idMarca = m.id;
    }
    if (!idMarca && data.marca) {
      const statsByName = await cargarStatsMarcaByNombre(data.marca);
      if (statsByName?.id) idMarca = statsByName.id;
    }
    if (idMarca) $('#pagoIdmarca').val(idMarca);

    // Info de la marca para plan/tiempo/valor
    let marcaInfo = null;
    if (idMarca && lista.length) {
      marcaInfo = lista.find(x => Number(x.id) === Number(idMarca)) || null;
    }
    if (!marcaInfo && lista.length && data.marca) {
      marcaInfo = lista.find(x => _norm(x.nombre_marca) === _norm(data.marca)) || null;
    }

    // Stats (para resumen)
    let stats = null;
    if (idMarca) {
      stats = await cargarStatsMarca(idMarca);
    } else if (data.marca) {
      stats = await cargarStatsMarcaByNombre(data.marca);
      if (stats?.id) $('#pagoIdmarca').val(stats.id);
    }

    // Plan, Tiempo y Monto
    const plan     = (marcaInfo?.plan ?? stats?.plan ?? '');
    const tiempo   = (marcaInfo?.tiempo ?? stats?.tiempo ?? '');
    const valorRaw = (marcaInfo?.valor ?? stats?.valor ?? '');
    const valor    = parseNum(valorRaw);

    $('#pagoPlan').val(plan);
    $('#pagoTiempo').val(tiempo);
    $('#pagoMonto').val(Number.isFinite(valor) ? valor : '');
    $('#pagoMetodo').val('');

    resetResumenUI();
    pintarResumen(stats, tiempo);

    new bootstrap.Modal(document.getElementById('modalPago')).show();
  });

  // Registrar pago
  $('#formPago').on('submit', function (e) {
    e.preventDefault();

    const idPublicidad = $('#pagoIdPublicidad').val();
    const idMarca      = $('#pagoIdmarca').val() || '';
    const metodo       = $('#pagoMetodo').val();
    const monto        = parseFloat($('#pagoMonto').val());
    const proxFecha    = $('#prox_fecha').val();

    if (!metodo || isNaN(monto) || !proxFecha) {
      Swal.fire('Completa todos los campos', '', 'warning');
      return;
    }

    $.ajax({
      url: 'registrar_pago_publicidad.php',
      method: 'POST',
      dataType: 'json',
      data: {
        id: idPublicidad,
        id_marca: idMarca,
        metodo: metodo,
        monto: monto,
        proxima_fecha: proxFecha
      },
      success: function (resp) {
        if (resp.success) {
          Swal.fire({ icon:'success', title:'Pago registrado', toast:true, timer:1500, position:'top-end', showConfirmButton:false });
          const modalElement = document.getElementById('modalPago');
          const modal = bootstrap.Modal.getInstance(modalElement);
          if (modal) modal.hide();
          tabla.ajax.reload(null, false);
        } else {
          Swal.fire('Error', resp.message || 'No se pudo registrar el pago', 'error');
        }
      },
      error: function () {
        Swal.fire('Error', 'No se pudo conectar con el servidor.', 'error');
      }
    });
  });
});
</script>

</body>
</html>
