<?php
session_start();
if (!isset($_SESSION['usuario']) || empty($_SESSION['usuario'])) {
    header('Location: ../../index.php');
    exit();
}
$usuario = $_SESSION['usuario'];
?>
<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8" />
<title>URBANVIEW</title>
<link rel="shortcut icon" href="../../resources/img/logour.ico" />
<meta name="viewport" content="width=device-width, initial-scale=1" />

<!-- Bootstrap 5 CSS -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
<!-- FontAwesome -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet" />
<!-- DataTables CSS -->
<link href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap5.min.css" rel="stylesheet" />

<style>
html, body {
  height: 100%;
  margin: 0;
  overflow: hidden;
  font-family: Arial, Helvetica, sans-serif;
}
body {
  display: flex;
  flex-direction: column;
}
.topbar {
  height: 60px;
  background: #343a40;
  color: #fff;
  display: flex;
  align-items: center;
  justify-content: space-between;
  padding: 0 20px;
  position: fixed;
  top: 0; left: 0; right: 0;
  z-index: 1000;
}
.wrapper {
  display: flex;
  flex-grow: 1;
  margin-top: 60px;
  height: calc(100vh - 60px);
  overflow: hidden;
}
.sidebar {
  width: 250px;
  background: #343a40;
  padding: 20px;
  overflow-y: auto;
  flex-shrink: 0;
  transition: width 0.3s ease;
}
.sidebar.collapsed {
  width: 80px;
}
.sidebar a {
  color: #fff;
  text-decoration: none;
  padding: 12px;
  display: flex;
  align-items: center;
}
.main-content {
  flex-grow: 1;
  height: 100%;
  display: flex;
  flex-direction: column;
  margin-left: 250px;
  padding: 20px;
  transition: margin-left 0.3s ease;
  overflow-y: auto;
}
.sidebar.collapsed ~ .main-content {
  margin-left: 80px;
}
.info {
  display: flex;
  align-items: center;
  gap: 1rem;
}
@media (max-width: 768px) {
  .sidebar {
    position: fixed;
    top: 60px;
    left: 0;
    height: calc(100% - 60px);
    z-index: 999;
    transform: translateX(-100%);
    transition: transform 0.3s ease;
    width: 250px;
  }
  .sidebar.show {
    transform: translateX(0);
  }
  .main-content {
    margin-left: 0 !important;
  }
  .wrapper {
    flex-direction: column;
  }
}
</style>
<style>
	.switch-wrapper {
  display: flex;
  justify-content: center;
  align-items: center;
}

.switch-custom {
  position: relative;
  display: inline-block;
  width: 70px;
  height: 34px;
}

.switch-custom input {
  opacity: 0;
  width: 0;
  height: 0;
}

.slider-custom {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  transition: 0.4s;
  border-radius: 34px;
  display: flex;
  align-items: center;
  justify-content: space-between;
  padding: 0 10px;
  font-size: 16px;
  color: white;
}

.slider-custom .icon-on,
.slider-custom .icon-off {
  opacity: 0;
  transition: opacity 0.3s ease;
}

input:checked + .slider-custom {
  background-color: #28a745; /* verde */
}

input:checked + .slider-custom .icon-on {
  opacity: 1;
}

input:checked + .slider-custom .icon-off {
  opacity: 0;
}

input:not(:checked) + .slider-custom .icon-off {
  opacity: 1;
}

input:not(:checked) + .slider-custom .icon-on {
  opacity: 0;
}


</style>

</head>
<body>
<header class="topbar">
  <button class="btn btn-dark" onclick="toggleSidebar()" aria-label="Toggle sidebar">
    <i class="fas fa-bars"></i>
  </button>
  <span>URBANVIEW</span>
  <div class="info">
    <span><?=htmlspecialchars($usuario, ENT_QUOTES, 'UTF-8');?></span>
    <span id="fechaActual"></span>
    <span id="horaActual"></span>
    <button class="btn btn-sm btn-danger" onclick="cerrarSesion(event)">
      <i class="fas fa-sign-out-alt"></i>
    </button>
  </div>
</header>

<div class="wrapper">
  <nav class="sidebar"><?php include "menu.php"; ?></nav>
  <div class="main-content">
    <div class="row mb-3">
      <div class="col-md-3">
        <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#agregarTableModal">
          <i class="fas fa-plus"></i> Agregar Table
        </button>
      </div>
    </div>

    <div class="table-responsive">
      <table id="tablet" class="table table-striped table-bordered" style="width:100%">
		  <thead class="table-dark">
			<tr>
			  <th>MARCA</th>
			  <th>MODELO</th>
			  <th>SERIE</th>
			  <th>ESTADO</th>
			  <th>ACTIVO</th>
			  <th>ACCIÓN</th>
			</tr>
		  </thead>
		  <tbody>
			<!-- PHP o AJAX aquí para cargar los modeloes -->
		  </tbody>
		</table>
    </div>
  </div>
</div>

<!-- Modal Agregar Table -->
<div class="modal fade" id="agregarTableModal" tabindex="-1" aria-labelledby="agregarTableModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form id="formAgregarmodelo" class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="agregarTableModalLabel">Agregar Nueva Table</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
      </div>
      <div class="modal-body">
        <div class="mb-3">
          <label for="marca" class="form-label">Marca*</label>
          <input type="text" class="form-control" id="marca" name="marca" required>
        </div>
		
		<div class="mb-3">
          <label for="modelo" class="form-label">Modelo*</label>
          <input type="text" class="form-control" id="modelo" name="modelo" required>
        </div>

		<div class="mb-3">
          <label for="serie" class="form-label">Serie*</label>
          <input type="text" class="form-control" id="serie" name="serie" required>
        </div>		
        
		<div class="mb-3">
		  <label for="estado" class="form-label">Estado*</label>
		  <select class="form-select" id="estado" name="estado" required>
			<option value="">Seleccione el estado</option>
			<option value="BUENO">BUENO</option>
			<option value="REGULAR">REGULAR</option>
			<option value="MALO">MALO</option>
		  </select>
		</div>
      </div>
      <div class="modal-footer">
        <button type="button" onclick="guardar()" class="btn btn-primary">Agregar</button>
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
      </div>
    </form>
  </div>
</div>

<!-- Modal Editar Table -->
<div class="modal fade" id="editarTableModal" tabindex="-1" aria-labelledby="editarTableModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form id="formEditarmodelo" class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="editarTableModalLabel">Editar Table</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
      </div>
      <div class="modal-body">
		<!-- Solo uno de estos inputs es necesario -->
		<input type="hidden" id="edit_id_table" name="id">

		<div class="mb-3">
		  <label for="editar_marca" class="form-label">Marca*</label>
		  <input type="text" class="form-control" id="edit_marca" name="edit_marca" required>
		</div>
		
		<div class="mb-3">
		  <label for="editar_modelo" class="form-label">Modelo*</label>
		  <input type="text" class="form-control" id="edit_modelo" name="edit_modelo" required>
		</div>

		<div class="mb-3">
		  <label for="editar_serie" class="form-label">Serie*</label>
		  <input type="text" class="form-control" id="edit_serie" name="edit_serie" required>
		</div>
		
		<div class="mb-3">
		  <label for="editar_estado" class="form-label">Estado*</label>
		  <select class="form-select" id="edit_estado" name="edit_estado" required>
			<option value="">Seleccione el estado</option>
			<option value="BUENO">BUENO</option>
			<option value="REGULAR">REGULAR</option>
			<option value="MALO">MALO</option>
		  </select>
		</div>
      </div>
	  
      <div class="modal-footer">
        <button type="button" id="btnGuardarmodelo" class="btn btn-primary">Guardar Cambios</button>
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
      </div>
    </form>
  </div>
</div>



<!-- JS: jQuery, Bootstrap, DataTables, SweetAlert -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="../../resources/js/menu_table.js"></script>
<script>
let sidebar = document.querySelector('.sidebar');

function actualizarHora() {
  const ahora = new Date();
  const opF = { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' };
  const opH = { hour: '2-digit', minute: '2-digit', second: '2-digit' };
  document.getElementById('fechaActual').textContent = ahora.toLocaleDateString('es-ES', opF);
  document.getElementById('horaActual').textContent = ahora.toLocaleTimeString('es-ES', opH);
}
setInterval(actualizarHora, 1000);
actualizarHora();

function toggleSidebar() {
  if (window.innerWidth <= 768) {
    sidebar.classList.toggle('show');
  } else {
    sidebar.classList.toggle('collapsed');
  }
}
document.addEventListener('click', function(e) {
  const toggleBtn = e.target.closest('button[onclick="toggleSidebar()"]');
  if (window.innerWidth <= 768 && !sidebar.contains(e.target) && !toggleBtn) {
    sidebar.classList.remove('show');
  }
});
function cerrarSesion(e) {
  Swal.fire({
    title: '¿Cerrar sesión?',
    icon: 'warning',
    showCancelButton: true,
    confirmButtonText: 'Sí',
    cancelButtonText: 'No'
  }).then(res => {
    if (res.isConfirmed) {
      fetch('../../controllers/usuario.php', {
        method: 'POST',
        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
        body: new URLSearchParams({boton: 'cerrar'})
      }).then(response => {
        if (response.ok) {
          window.location.href = '../../index.php';
        } else {
          throw new Error('Error al cerrar sesión');
        }
      }).catch(err => {
        Swal.fire('Error', err.message, 'error');
      });
    }
  });
}

$(document).on('change', '.toggle-switch', function() {
    let checkbox = $(this);
    let id = checkbox.data('id');
    let nuevoEstado = checkbox.is(':checked') ? 1 : 0;

    $.ajax({
        url: 'actualizar_estado_table.php', // Archivo PHP que procesa la actualización
        method: 'POST',
        data: { id: id, activa: nuevoEstado },
        success: function(response) {
            // Puedes procesar la respuesta si quieres mostrar mensajes
            checkbox.data('estado', nuevoEstado); // Actualiza el atributo data-estado
        },
        error: function() {
            alert('Error al actualizar el estado.');
            // Opcional: revertir el checkbox si falla
            checkbox.prop('checked', !nuevoEstado);
        }
    });
});
</script>
<script>
	function guardar() {
	  const marca = $('#marca').val().trim();
	  const modelo = $('#modelo').val().trim();
	  const serie = $('#serie').val().trim();
	  const estado = $('#estado').val().trim();

	  if (!marca || !modelo || !serie || !estado) {
		Swal.fire({
		  icon: 'warning',
		  title: 'Campos obligatorios',
		  text: 'Por favor completa todos los campos.',
		});
		return;
	  }

	  const formData = new FormData();
	  formData.append('marca', marca);
	  formData.append('modelo', modelo);
	  formData.append('serie', serie);
	  formData.append('estado', estado);

	  fetch('guardar_table.php', {
		method: 'POST',
		body: formData
	  })
	  .then(response => response.json())
	  .then(data => {
		if (data.success) {
		  Swal.fire({
			icon: 'success',
			title: 'Modelo guardado',
			text: 'El modelo se ha guardado correctamente.',
			timer: 2000,
			showConfirmButton: false
		  });

		  $('#agregarTableModalModal').modal('hide');
		  $('#formAgregarmodelo')[0].reset();
		  $('#tablet').DataTable().ajax.reload(null, false); // Refrescar tabla sin recargar página
		} else {
		  Swal.fire({
			icon: 'error',
			title: 'Error',
			text: data.message || 'Ocurrió un error al guardar el modelo.'
		  });
		}
	  })
	  .catch(error => {
		console.error(error);
		Swal.fire({
		  icon: 'error',
		  title: 'Error del servidor',
		  text: 'No se pudo guardar la table. Inténtalo de nuevo más tarde.'
		});
	  });
	}


</script>

<script>
  $(document).on('click', '.toggle-editar', function () {
    let idtable = $(this).data('id');            
    let marca = $(this).data('marca');           
    let modelo = $(this).data('modelo');    
    let serie = $(this).data('serie');    
    let estado = $(this).data('estado');    

    // Llenar campos del formulario
    $('#edit_id_table').val(idtable);          
    $('#edit_marca').val(marca);             
    $('#edit_modelo').val(modelo);         
    $('#edit_serie').val(serie);        
    $('#edit_estado').val(estado);        

    // Mostrar modal
    $('#editarTableModal').modal('show');
  });
</script>

<script>
function actualizarTable() {
  const id = $('#edit_id_table').val();
  const marca = $('#edit_marca').val().trim();
  const modelo = $('#edit_modelo').val().trim();
  const serie = $('#edit_serie').val().trim();
  const estado = $('#edit_estado').val().trim();

  if (!marca || !modelo || !serie || !estado) {
    Swal.fire('Campos requeridos', 'Debes completar todos los campos.', 'warning');
    return;
  }

  $.post('editar_table.php', { id, marca, modelo, serie, estado }, function (data) {
    if (data.success) {
      Swal.fire({
        icon: 'success',
        title: 'Actualizado',
        text: 'El registro se actualizó correctamente.',
        timer: 2000,
        showConfirmButton: false
      });

      $('#editarTableModal').modal('hide');

      // Recargar tabla si usas DataTables
      //$('#tablet').DataTable().ajax.reload(null, false);
	  $('#tablet').DataTable().ajax.reload(null, false); // Refrescar tabla sin recargar página
    } else {
      Swal.fire({
        icon: 'error',
        title: 'Error',
        text: data.message || 'Ocurrió un error al guardar.'
      });
    }
  }, 'json');
}

// Asociar al botón
$(document).ready(function () {
  $('#btnGuardarmodelo').on('click', function (e) {
    e.preventDefault();
    actualizarTable();
  });
});
</script>

<script>
$(document).on('click', '.btn-eliminar', function () {
  const id = $(this).data('id');
	
  Swal.fire({
    title: '¿Estás segura?',
    text: 'Esta acción eliminará la table permanentemente.',
    icon: 'warning',
    showCancelButton: true,
    confirmButtonText: 'Sí, eliminar',
    cancelButtonText: 'Cancelar'
  }).then((result) => {	  
    if (result.isConfirmed) {
      $.post('eliminar_table.php', { id }, function (response) {
        if (response.success) {
			
          Swal.fire('Eliminada', 'La table fue eliminada correctamente.', 'success');

          // Elimina visualmente la fila sin recargar
          $('button.btn-eliminar[data-id="' + id + '"]').closest('tr').remove();
		  $('#tablet').DataTable().ajax.reload(null, false); // Refrescar tabla sin recargar página
		  
        } else {
          Swal.fire('Error', response.message || 'No se pudo eliminar.', 'error');
        }
      }, 'json');
    }
  });
});

</script>
</body>
</html>
