<?php
session_start();
if (!isset($_SESSION['usuario']) || empty($_SESSION['usuario'])) {
    header('Location: ../../index.php');
    exit();
}
$usuario = $_SESSION['usuario'];
?>
<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8" />
<title>URBANVIEW</title>
<link rel="shortcut icon" href="../../resources/img/logour.ico" />
<meta name="viewport" content="width=device-width, initial-scale=1" />

<!-- Bootstrap 5 CSS -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
<!-- FontAwesome -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet" />
<!-- DataTables CSS -->
<link href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap5.min.css" rel="stylesheet" />

<style>
html, body {
  height: 100%;
  margin: 0;
  overflow: hidden;
  font-family: Arial, Helvetica, sans-serif;
}
body {
  display: flex;
  flex-direction: column;
}
.topbar {
  height: 60px;
  background: #343a40;
  color: #fff;
  display: flex;
  align-items: center;
  justify-content: space-between;
  padding: 0 20px;
  position: fixed;
  top: 0; left: 0; right: 0;
  z-index: 1000;
}
.wrapper {
  display: flex;
  flex-grow: 1;
  margin-top: 60px;
  height: calc(100vh - 60px);
  overflow: hidden;
}
.sidebar {
  width: 250px;
  background: #343a40;
  padding: 20px;
  overflow-y: auto;
  flex-shrink: 0;
  transition: width 0.3s ease;
}
.sidebar.collapsed {
  width: 80px;
}
.sidebar a {
  color: #fff;
  text-decoration: none;
  padding: 12px;
  display: flex;
  align-items: center;
}
.main-content {
  flex-grow: 1;
  height: 100%;
  display: flex;
  flex-direction: column;
  margin-left: 250px;
  padding: 20px;
  transition: margin-left 0.3s ease;
  overflow-y: auto;
}
.sidebar.collapsed ~ .main-content {
  margin-left: 80px;
}
.info {
  display: flex;
  align-items: center;
  gap: 1rem;
}
@media (max-width: 768px) {
  .sidebar {
    position: fixed;
    top: 60px;
    left: 0;
    height: calc(100% - 60px);
    z-index: 999;
    transform: translateX(-100%);
    transition: transform 0.3s ease;
    width: 250px;
  }
  .sidebar.show {
    transform: translateX(0);
  }
  .main-content {
    margin-left: 0 !important;
  }
  .wrapper {
    flex-direction: column;
  }
}
</style>
<style>
	.switch-wrapper {
  display: flex;
  justify-content: center;
  align-items: center;
}

.switch-custom {
  position: relative;
  display: inline-block;
  width: 70px;
  height: 34px;
}

.switch-custom input {
  opacity: 0;
  width: 0;
  height: 0;
}

.slider-custom {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  transition: 0.4s;
  border-radius: 34px;
  display: flex;
  align-items: center;
  justify-content: space-between;
  padding: 0 10px;
  font-size: 16px;
  color: white;
}

.slider-custom .icon-on,
.slider-custom .icon-off {
  opacity: 0;
  transition: opacity 0.3s ease;
}

input:checked + .slider-custom {
  background-color: #28a745; /* verde */
}

input:checked + .slider-custom .icon-on {
  opacity: 1;
}

input:checked + .slider-custom .icon-off {
  opacity: 0;
}

input:not(:checked) + .slider-custom .icon-off {
  opacity: 1;
}

input:not(:checked) + .slider-custom .icon-on {
  opacity: 0;
}


</style>

</head>
<body>
<header class="topbar">
  <button class="btn btn-dark" onclick="toggleSidebar()" aria-label="Toggle sidebar">
    <i class="fas fa-bars"></i>
  </button>
  <span>URBANVIEW</span>
  <div class="info">
    <span><?=htmlspecialchars($usuario, ENT_QUOTES, 'UTF-8');?></span>
    <span id="fechaActual"></span>
    <span id="horaActual"></span>
    <button class="btn btn-sm btn-danger" onclick="cerrarSesion(event)">
      <i class="fas fa-sign-out-alt"></i>
    </button>
  </div>
</header>

<div class="wrapper">
  <nav class="sidebar"><?php include "menu.php"; ?></nav>
  <div class="main-content">
    <div class="row mb-3">
      <div class="col-md-3">
        <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#agregarVehiculoModal">
          <i class="fas fa-plus"></i> Agregar Vehiculo
        </button>
      </div>
    </div>

    <div class="table-responsive">
      <table id="vehiculo" class="table table-striped table-bordered" style="width:100%">
		  <thead class="table-dark">
			<tr>
			  <th>PLACA</th>
			  <th>NOMBRES</th>
			  <th>TELEFONO</th>
			  <th>COOPERATIVA/COMPAÑIA</th>
			  <th>ZONA</th>
			  <th>CANTON</th>			  
			  <th>ACTIVO</th>			  
			  <th>#SERIE TABLE</th>
			  <th>ACCIÓN</th>
			</tr>
		  </thead>
		  <tbody>
			<!-- PHP o AJAX aquí para cargar los modeloes -->
		  </tbody>
		</table>
    </div>
  </div>
</div>

<!-- Modal Agregar Table -->
<div class="modal fade" id="agregarVehiculoModal" tabindex="-1" aria-labelledby="agregarVehiculoModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form id="formAgregarVehiculo" class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="agregarVehiculoModalLabel">Agregar Nueva Vehiculo</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
      </div>
      <div class="modal-body">
		<div class="mb-3">
          <label for="cooperativa" class="form-label">Cooperativa/Compañia*</label>
          <input type="text" class="form-control" id="cooperativa" name="cooperativa" required>
        </div>
		
        <div class="row">
		  <div class="col-md-6 mb-3">
			<label for="placa" class="form-label">Placa*</label>
			<input type="text" class="form-control" id="placa" name="placa" required>
		  </div>
		  <div class="col-md-6 mb-3">
			<label for="telefono" class="form-label">Teléfono*</label>
			<input type="text" class="form-control" id="telefono" name="telefono" required>
		  </div>
		</div>
		
		<div class="mb-3">
          <label for="nombres" class="form-label">Nombres*</label>
          <input type="text" class="form-control" id="nombres" name="nombres" required>
        </div>

		<div class="row">
		  <div class="col-md-6 mb-3">
			<label for="zona" class="form-label">Zona</label>
			<select name="zona" id="zona" class="form-control" placeholder="Selecciona la zona..." required></select>
		  </div>
		  <div class="col-md-6 mb-3">
			<label for="canton" class="form-label">Canton</label>
			<select name="canton" id="canton" class="form-control" placeholder="Selecciona el canton..." required></select>
		  </div>
		</div>
        
		<div class="mb-3">
          <label for="table" class="form-label">Table</label>
          <select name="table" id="table" class="form-control" placeholder="Selecciona la table..." required></select> 
        </div>
		
      </div>
      <div class="modal-footer">
        <button type="button" onclick="guardar()" class="btn btn-primary">Agregar</button>
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
      </div>
    </form>
  </div>
</div>

<!-- Modal Editar vehiculo -->
<div class="modal fade" id="editarVehiculoModal" tabindex="-1" aria-labelledby="editarVehiculoModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form id="formEditarVehiculo" class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="editarVehiculoModalLabel">Editar Vehiculo</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
      </div>
      <div class="modal-body">
		<!-- Solo uno de estos inputs es necesario -->
		<input type="hidden" id="edit_id_vehiculo" name="id">
		<div class="mb-3">
          <label for="edit_cooperativa" class="form-label">Cooperativa/Compañia*</label>
          <input type="text" class="form-control" id="edit_cooperativa" name="edit_cooperativa" required>
        </div>
		<div class="row">
		  <div class="col-md-6 mb-3">
			<label for="edit_placa" class="form-label">Placa*</label>
			<input type="text" class="form-control" id="edit_placa" name="edit_placa" required>
		  </div>
		  <div class="col-md-6 mb-3">
			<label for="edit_telefono" class="form-label">Teléfono*</label>
			<input type="text" class="form-control" id="edit_telefono" name="edit_telefono" required>
		  </div>
		</div>
		
		<div class="mb-3">
          <label for="edit_nombres" class="form-label">Nombres*</label>
          <input type="text" class="form-control" id="edit_nombres" name="edit_nombres" required>
        </div>

		<div class="row">
		  <div class="col-md-6 mb-3">
			<label for="edit_zona" class="form-label">Zona</label>
			<select name="edit_zona" id="edit_zona" class="form-control" placeholder="Selecciona la zona..." required></select>
		  </div>
		  <div class="col-md-6 mb-3">
			<label for="edit_canton" class="form-label">Canton</label>
			<select name="edit_canton" id="edit_canton" class="form-control" placeholder="Selecciona el canton..." required></select>
		  </div>
		</div>
        
		<div class="mb-3">
          <label for="edit_table" class="form-label">Table</label>
          <select name="edit_table" id="edit_table" class="form-control" placeholder="Selecciona la table..." required></select> 
        </div>
      </div>
	  
      <div class="modal-footer">
        <button type="button" id="btnGuardarmodelo" class="btn btn-primary">Guardar Cambios</button>
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
      </div>
    </form>
  </div>
</div>



<!-- JS: jQuery, Bootstrap, DataTables, SweetAlert -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="../../resources/js/menu_vehiculo.js"></script>
<script>
let sidebar = document.querySelector('.sidebar');

function actualizarHora() {
  const ahora = new Date();
  const opF = { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' };
  const opH = { hour: '2-digit', minute: '2-digit', second: '2-digit' };
  document.getElementById('fechaActual').textContent = ahora.toLocaleDateString('es-ES', opF);
  document.getElementById('horaActual').textContent = ahora.toLocaleTimeString('es-ES', opH);
}
setInterval(actualizarHora, 1000);
actualizarHora();

function toggleSidebar() {
  if (window.innerWidth <= 768) {
    sidebar.classList.toggle('show');
  } else {
    sidebar.classList.toggle('collapsed');
  }
}
document.addEventListener('click', function(e) {
  const toggleBtn = e.target.closest('button[onclick="toggleSidebar()"]');
  if (window.innerWidth <= 768 && !sidebar.contains(e.target) && !toggleBtn) {
    sidebar.classList.remove('show');
  }
});
function cerrarSesion(e) {
  Swal.fire({
    title: '¿Cerrar sesión?',
    icon: 'warning',
    showCancelButton: true,
    confirmButtonText: 'Sí',
    cancelButtonText: 'No'
  }).then(res => {
    if (res.isConfirmed) {
      fetch('../../controllers/usuario.php', {
        method: 'POST',
        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
        body: new URLSearchParams({boton: 'cerrar'})
      }).then(response => {
        if (response.ok) {
          window.location.href = '../../index.php';
        } else {
          throw new Error('Error al cerrar sesión');
        }
      }).catch(err => {
        Swal.fire('Error', err.message, 'error');
      });
    }
  });
}

$(document).on('change', '.toggle-switch', function() {
    let checkbox = $(this);
    let id = checkbox.data('id');
    let nuevoEstado = checkbox.is(':checked') ? 1 : 0;

    $.ajax({
        url: 'actualizar_estado_vehuculo.php', // Archivo PHP que procesa la actualización
        method: 'POST',
        data: { id: id, activa: nuevoEstado },
        success: function(response) {
            // Puedes procesar la respuesta si quieres mostrar mensajes
            checkbox.data('estado', nuevoEstado); // Actualiza el atributo data-estado
        },
        error: function() {
            alert('Error al actualizar el estado.');
            // Opcional: revertir el checkbox si falla
            checkbox.prop('checked', !nuevoEstado);
        }
    });
});
</script>
<script>
	function guardar() {
		const cooperativa = $('#cooperativa').val().trim();
		const placa = $('#placa').val().trim();
		const telefono = $('#telefono').val().trim();
		const nombres = $('#nombres').val().trim();
		const zona = $('#zona').val().trim();
		const canton = $('#canton').val().trim();
		const table = $('#table').val().trim();

		if (!cooperativa || !placa || !telefono || !nombres || !zona || !canton) {
			Swal.fire({
				icon: 'warning',
				title: 'Campos obligatorios',
				text: 'Por favor completa todos los campos.',
			});
			return;
		}

		const formData = new FormData();
		formData.append('cooperativa', cooperativa);
		formData.append('placa', placa);
		formData.append('telefono', telefono);
		formData.append('nombres', nombres);
		formData.append('zona', zona);
		formData.append('canton', canton);
		formData.append('table', table);

		fetch('guardar_vehiculo.php', {
			method: 'POST',
			body: formData
		})
		.then(response => response.json())
		.then(data => {
			if (data.success) {
				Swal.fire({
					icon: 'success',
					title: 'Guardado correctamente',
					text: 'Los datos se han guardado exitosamente.',
					timer: 2000,
					showConfirmButton: false
				});
				$('#agregarVehiculoModal').modal('hide');
				$('#formAgregarVehiculo')[0].reset();
				$('#vehiculo').DataTable().ajax.reload(null, false);
			} else {
				Swal.fire({
					icon: 'error',
					title: 'Error',
					text: data.message || 'Ocurrió un error al guardar los datos.'
				});
			}
		})
		.catch(error => {
			console.error(error);
			Swal.fire({
				icon: 'error',
				title: 'Error del servidor',
				text: 'No se pudo guardar. Inténtalo de nuevo más tarde.'
			});
		});
	}
</script>

<script>
//Funcion table
	$(document).ready(function() {
		$.ajax({
			type: "POST",
			url: "datos.php?Accion=GetTable",			
			success: function(response)
			{
				$('#table').html(response).fadeIn();
			}
		}); 
	});
</script>
<script>
//Funcion table
	$(document).ready(function() {
		$.ajax({
			type: "POST",
			url: "datos.php?Accion=GetTable",			
			success: function(response)
			{
				$('#edit_table').html(response).fadeIn();
			}
		}); 
	});
</script>
<script>
$(document).ready(function () {
  // Cargar zonas al iniciar
  $.ajax({
    type: "POST",
    url: "datos.php?Accion=GetZonas", // este endpoint debe devolver <option value="...">...</option>
    success: function (response) {
      $('#zona').html('<option value="" disabled selected>Selecciona la zona...</option>' + response);
    },
    error: function () {
      Swal.fire('Error', 'No se pudieron cargar las zonas.', 'error');
    }
  });

  // Cuando cambia la zona, cargar los cantones relacionados
  $('#zona').on('change', function () {
    const idZona = $(this).val();
    if (!idZona) return;

    $.ajax({
      type: "POST",
      url: "datos.php?Accion=GetCantonesPorZona",
      data: { id_zona: idZona },
      success: function (response) {
        $('#canton').html('<option value="" disabled selected>Selecciona el cantón...</option>' + response);
      },
      error: function () {
        Swal.fire('Error', 'No se pudieron cargar los cantones.', 'error');
      }
    });
  });
});
</script>
<script>
$(document).ready(function () {
  // Cargar zonas al iniciar
  $.ajax({
    type: "POST",
    url: "datos.php?Accion=GetZonas", // este endpoint debe devolver <option value="...">...</option>
    success: function (response) {
      $('#edit_zona').html('<option value="" disabled selected>Selecciona la zona...</option>' + response);
    },
    error: function () {
      Swal.fire('Error', 'No se pudieron cargar las zonas.', 'error');
    }
  });

  // Cuando cambia la zona, cargar los cantones relacionados
  $('#edit_zona').on('change', function () {
    const idZona = $(this).val();
    if (!idZona) return;

    $.ajax({
      type: "POST",
      url: "datos.php?Accion=GetCantonesPorZona",
      data: { id_zona: idZona },
      success: function (response) {
        $('#edit_canton').html('<option value="" disabled selected>Selecciona el cantón...</option>' + response);
      },
      error: function () {
        Swal.fire('Error', 'No se pudieron cargar los cantones.', 'error');
      }
    });
  });
});
</script>

<script>
  $(document).on('click', '.toggle-editar', function () {
    let idvehiculo = $(this).data('id');            
    let placa = $(this).data('placa');           
    let nombre = $(this).data('nombre');    
    let telefono = $(this).data('telefono');    
    let cooperativa = $(this).data('cooperativa');       
    let id_zona = $(this).data('id_zona');    
    let id_canton = $(this).data('id_canton');    
    let id_table = $(this).data('id_table');    

    // Llenar campos del formulario
    $('#edit_id_vehiculo').val(idvehiculo);          
    $('#edit_placa').val(placa);             
    $('#edit_nombres').val(nombre);         
    $('#edit_telefono').val(telefono);        
    $('#edit_cooperativa').val(cooperativa);        
    $('#edit_zona').val(id_zona);        
    $('#edit_canton').val(id_canton);        
    $('#edit_table').val(id_table);        

    // Mostrar modal
    $('#editarVehiculoModal').modal('show');
  });
</script>

<script>
function actualizarVehivulo() {
  const id = $('#edit_id_vehiculo').val();
  const placa = $('#edit_placa').val().trim();
  const nombre = $('#edit_nombres').val().trim();
  const telefono = $('#edit_telefono').val().trim();
  const cooperativa = $('#edit_cooperativa').val().trim();
  const id_zona = $('#edit_zona').val().trim();
  const id_canton = $('#edit_canton').val().trim();
  const id_table = $('#edit_table').val().trim();

  if (!placa || !nombre || !telefono || !cooperativa || !id_zona || !id_canton || !id_table) {
    Swal.fire('Campos requeridos', 'Debes completar todos los campos.', 'warning');
    return;
  }

  $.post('editar_vehiculo.php', { id, placa, nombre, telefono, cooperativa, id_zona, id_canton, id_table }, function (data) {
    if (data.success) {
      Swal.fire({
        icon: 'success',
        title: 'Actualizado',
        text: 'El registro se actualizó correctamente.',
        timer: 2000,
        showConfirmButton: false
      });

      $('#editarVehiculoModal').modal('hide');

      // Recargar tabla si usas DataTables
      //$('#tablet').DataTable().ajax.reload(null, false);
	  $('#vehiculo').DataTable().ajax.reload(null, false); // Refrescar tabla sin recargar página
    } else {
      Swal.fire({
        icon: 'error',
        title: 'Error',
        text: data.message || 'Ocurrió un error al guardar.'
      });
    }
  }, 'json');
}

// Asociar al botón
$(document).ready(function () {
  $('#btnGuardarmodelo').on('click', function (e) {
    e.preventDefault();
    actualizarVehivulo();
  });
});
</script>

<script>
$(document).on('click', '.btn-eliminar', function () {
  const id = $(this).data('id');
	
  Swal.fire({
    title: '¿Estás segura?',
    text: 'Esta acción eliminará el vehiculo permanentemente.',
    icon: 'warning',
    showCancelButton: true,
    confirmButtonText: 'Sí, eliminar',
    cancelButtonText: 'Cancelar'
  }).then((result) => {	  
    if (result.isConfirmed) {
      $.post('eliminar_vehiculo.php', { id }, function (response) {
        if (response.success) {
			
          Swal.fire('Eliminada', 'El Vehiculo fue eliminado correctamente.', 'success');

          // Elimina visualmente la fila sin recargar
          $('button.btn-eliminar[data-id="' + id + '"]').closest('tr').remove();
		  $('#tablet').DataTable().ajax.reload(null, false); // Refrescar tabla sin recargar página
		  
        } else {
          Swal.fire('Error', response.message || 'No se pudo eliminar.', 'error');
        }
      }, 'json');
    }
  });
});

</script>
</body>
</html>
