<?php
session_start();
if (!isset($_SESSION['usuario']) || empty($_SESSION['usuario'])) {
    header('Location: ../../index.php');
    exit();
}
$usuario = $_SESSION['usuario'];
?>
<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8" />
<title>URBANVIEW</title>
<link rel="shortcut icon" href="../../resources/img/logour.ico" />
<meta name="viewport" content="width=device-width, initial-scale=1" />

<!-- Bootstrap 5 CSS -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
<!-- FontAwesome -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet" />
<!-- DataTables CSS -->
<link href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap5.min.css" rel="stylesheet" />

<style>
html, body {
  height: 100%;
  margin: 0;
  overflow: hidden;
  font-family: Arial, Helvetica, sans-serif;
}
body {
  display: flex;
  flex-direction: column;
}
.topbar {
  height: 60px;
  background: #343a40;
  color: #fff;
  display: flex;
  align-items: center;
  justify-content: space-between;
  padding: 0 20px;
  position: fixed;
  top: 0; left: 0; right: 0;
  z-index: 1000;
}
.wrapper {
  display: flex;
  flex-grow: 1;
  margin-top: 60px;
  height: calc(100vh - 60px);
  overflow: hidden;
}
.sidebar {
  width: 250px;
  background: #343a40;
  padding: 20px;
  overflow-y: auto;
  flex-shrink: 0;
  transition: width 0.3s ease;
}
.sidebar.collapsed {
  width: 80px;
}
.sidebar a {
  color: #fff;
  text-decoration: none;
  padding: 12px;
  display: flex;
  align-items: center;
}
.main-content {
  flex-grow: 1;
  height: 100%;
  display: flex;
  flex-direction: column;
  margin-left: 250px;
  padding: 20px;
  transition: margin-left 0.3s ease;
  overflow-y: auto;
}
.sidebar.collapsed ~ .main-content {
  margin-left: 80px;
}
.info {
  display: flex;
  align-items: center;
  gap: 1rem;
}
@media (max-width: 768px) {
  .sidebar {
    position: fixed;
    top: 60px;
    left: 0;
    height: calc(100% - 60px);
    z-index: 999;
    transform: translateX(-100%);
    transition: transform 0.3s ease;
    width: 250px;
  }
  .sidebar.show {
    transform: translateX(0);
  }
  .main-content {
    margin-left: 0 !important;
  }
  .wrapper {
    flex-direction: column;
  }
}
</style>
<style>
	.switch-wrapper {
  display: flex;
  justify-content: center;
  align-items: center;
}

.switch-custom {
  position: relative;
  display: inline-block;
  width: 70px;
  height: 34px;
}

.switch-custom input {
  opacity: 0;
  width: 0;
  height: 0;
}

.slider-custom {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  transition: 0.4s;
  border-radius: 34px;
  display: flex;
  align-items: center;
  justify-content: space-between;
  padding: 0 10px;
  font-size: 16px;
  color: white;
}

.slider-custom .icon-on,
.slider-custom .icon-off {
  opacity: 0;
  transition: opacity 0.3s ease;
}

input:checked + .slider-custom {
  background-color: #28a745; /* verde */
}

input:checked + .slider-custom .icon-on {
  opacity: 1;
}

input:checked + .slider-custom .icon-off {
  opacity: 0;
}

input:not(:checked) + .slider-custom .icon-off {
  opacity: 1;
}

input:not(:checked) + .slider-custom .icon-on {
  opacity: 0;
}


</style>

</head>
<body>
<header class="topbar">
  <button class="btn btn-dark" onclick="toggleSidebar()" aria-label="Toggle sidebar">
    <i class="fas fa-bars"></i>
  </button>
  <span>URBANVIEW</span>
  <div class="info">
    <span><?=htmlspecialchars($usuario, ENT_QUOTES, 'UTF-8');?></span>
    <span id="fechaActual"></span>
    <span id="horaActual"></span>
    <button class="btn btn-sm btn-danger" onclick="cerrarSesion(event)">
      <i class="fas fa-sign-out-alt"></i>
    </button>
  </div>
</header>

<div class="wrapper">
  <nav class="sidebar"><?php include "menu.php"; ?></nav>
  <div class="main-content">
    <div class="row mb-3">
      <div class="col-md-3">
        <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#agregarZonaModal">
          <i class="fas fa-plus"></i> Agregar Zona
        </button>
      </div>
    </div>

    <div class="table-responsive">
      <table id="zona" class="table table-striped table-bordered" style="width:100%">
        <thead class="table-dark">
          <tr>
            <th>ZONA</th>
            <th>ACTIVO</th>
            <th>ACCIÓN</th>
          </tr>
        </thead>
        <tbody>
          <!-- Aquí puedes cargar los datos dinámicamente usando AJAX o PHP -->
        </tbody>
      </table>
    </div>
  </div>
</div>

<!-- Modal Agregar Zona -->
<div class="modal fade" id="agregarZonaModal" tabindex="-1" aria-labelledby="agregarZonaModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form id="formAgregarZona" class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="agregarZonaModalLabel">Agregar Nueva Zona</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
      </div>
      <div class="modal-body">
        <div class="mb-3">
          <label for="zona" class="form-label">Nombre de la Zona</label>
          <input type="text" class="form-control" id="zona_n" name="zona_n" required>
        </div>
        
      </div>
      <div class="modal-footer">
        <button type="button" onclick="guardar()" class="btn btn-primary">Agregar</button>
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
      </div>
    </form>
  </div>
</div>

<!-- Modal Editar Zona -->
<div class="modal fade" id="editarZonaModal" tabindex="-1" aria-labelledby="editarZonaModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form id="formEditarZona" class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="editarZonaModalLabel">Editar Zona</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
      </div>
      <div class="modal-body">
        <input type="hidden" id="edit_id_zona" name="id">
        <div class="mb-3">
          <label for="edit_zona" class="form-label">Nombre de la Zona</label>
          <input type="text" class="form-control" id="edit_zona" name="zona" required>
        </div>
      </div>
      <div class="modal-footer">
         <button type="button" id="btnGuardarZona" class="btn btn-primary">Guardar Cambios</button>

        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
      </div>
    </form>
  </div>
</div>


<!-- JS: jQuery, Bootstrap, DataTables, SweetAlert -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="../../resources/js/menu_zona.js"></script>
<script>
let sidebar = document.querySelector('.sidebar');

function actualizarHora() {
  const ahora = new Date();
  const opF = { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' };
  const opH = { hour: '2-digit', minute: '2-digit', second: '2-digit' };
  document.getElementById('fechaActual').textContent = ahora.toLocaleDateString('es-ES', opF);
  document.getElementById('horaActual').textContent = ahora.toLocaleTimeString('es-ES', opH);
}
setInterval(actualizarHora, 1000);
actualizarHora();

function toggleSidebar() {
  if (window.innerWidth <= 768) {
    sidebar.classList.toggle('show');
  } else {
    sidebar.classList.toggle('collapsed');
  }
}
document.addEventListener('click', function(e) {
  const toggleBtn = e.target.closest('button[onclick="toggleSidebar()"]');
  if (window.innerWidth <= 768 && !sidebar.contains(e.target) && !toggleBtn) {
    sidebar.classList.remove('show');
  }
});
function cerrarSesion(e) {
  Swal.fire({
    title: '¿Cerrar sesión?',
    icon: 'warning',
    showCancelButton: true,
    confirmButtonText: 'Sí',
    cancelButtonText: 'No'
  }).then(res => {
    if (res.isConfirmed) {
      fetch('../../controllers/usuario.php', {
        method: 'POST',
        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
        body: new URLSearchParams({boton: 'cerrar'})
      }).then(response => {
        if (response.ok) {
          window.location.href = '../../index.php';
        } else {
          throw new Error('Error al cerrar sesión');
        }
      }).catch(err => {
        Swal.fire('Error', err.message, 'error');
      });
    }
  });
}

$(document).on('change', '.toggle-switch', function() {
    let checkbox = $(this);
    let id = checkbox.data('id');
    let nuevoEstado = checkbox.is(':checked') ? 1 : 0;

    $.ajax({
        url: 'actualizar_estado_zona.php', // Archivo PHP que procesa la actualización
        method: 'POST',
        data: { id: id, activa: nuevoEstado },
        success: function(response) {
            // Puedes procesar la respuesta si quieres mostrar mensajes
            checkbox.data('estado', nuevoEstado); // Actualiza el atributo data-estado
        },
        error: function() {
            alert('Error al actualizar el estado.');
            // Opcional: revertir el checkbox si falla
            checkbox.prop('checked', !nuevoEstado);
        }
    });
});


</script>
<script>
function guardar() {
  const zona = $('#zona_n').val().trim();
	///alert (zona);
  if (!zona) {
    Swal.fire({
      icon: 'warning',
      title: 'Campo obligatorio',
      text: 'Por favor ingresa el nombre de la zona.',
    });
    return;
  }

  const formData = new FormData();
  formData.append('zona', zona);

  fetch('guardar_zona.php', {
    method: 'POST',
    body: formData
  })
  .then(response => response.json())
  .then(data => {
    if (data.success) {
      Swal.fire({
        icon: 'success',
        title: 'Zona agregada',
        text: 'La zona se ha guardado correctamente.',
        timer: 2000,
        showConfirmButton: false
      });
      $('#agregarZonaModal').modal('hide');
      $('#formAgregarZona')[0].reset();
      setTimeout(() => location.reload(), 2000);
    } else {
      Swal.fire({
        icon: 'error',
        title: 'Error',
        text: data.message || 'Ocurrió un error al guardar la zona.'
      });
    }
  })
  .catch(error => {
    console.error(error);
    Swal.fire({
      icon: 'error',
      title: 'Error del servidor',
      text: 'No se pudo guardar la zona. Inténtalo de nuevo más tarde.'
    });
  });
}
</script>
<script>
	$(document).on('click', '.toggle-editar', function () {
	  let id = $(this).data('id');
	  let zona = $(this).data('zona');

	  $('#edit_id_zona').val(id);
	  $('#edit_zona').val(zona);

	  $('#editarZonaModal').modal('show');
	});

</script>
<script>
function actualizar() {
  const id = $('#edit_id_zona').val();
  const zona = $('#edit_zona').val().trim();

  if (!zona) {
    Swal.fire('Campo requerido', 'Debes ingresar un nombre de zona.', 'warning');
    return;
  }

  $.post('editar_zona.php', { id, zona }, function (data) {
    if (data.success) {
      Swal.fire({
        icon: 'success',
        title: 'Zona actualizada',
        text: 'La zona se ha guardado correctamente.',
        timer: 2000,
        showConfirmButton: false
      });

      $('#editarZonaModal').modal('hide');

      // Actualiza la fila directamente sin recargar
      let fila = $('button.toggle-editar[data-id="' + id + '"]').closest('tr');
      fila.find('td').eq(0).text(zona); // Ajusta el índice si no es la primera columna
      fila.find('.toggle-editar').data('zona', zona);

    } else {
      Swal.fire({
        icon: 'error',
        title: 'Error',
        text: data.message || 'Ocurrió un error al guardar la zona.'
      });
    }
  }, 'json');
}

// Asociar al botón
$(document).ready(function () {
  $('#btnGuardarZona').on('click', function (e) {
    e.preventDefault();
    actualizar();
  });
});
</script>
<script>
$(document).on('click', '.btn-eliminar', function () {
  const id = $(this).data('id');
	
  Swal.fire({
    title: '¿Estás segura?',
    text: 'Esta acción eliminará la zona permanentemente.',
    icon: 'warning',
    showCancelButton: true,
    confirmButtonText: 'Sí, eliminar',
    cancelButtonText: 'Cancelar'
  }).then((result) => {	  
    if (result.isConfirmed) {
      $.post('eliminar_zona.php', { id }, function (response) {
        if (response.success) {
			
          Swal.fire('Eliminada', 'La zona fue eliminada correctamente.', 'success');

          // Elimina visualmente la fila sin recargar
          $('button.btn-eliminar[data-id="' + id + '"]').closest('tr').remove();
        } else {
          Swal.fire('Error', response.message || 'No se pudo eliminar.', 'error');
        }
      }, 'json');
    }
  });
});

</script>



</body>
</html>
